type
  TCustomPropListBox=class(TCustomListBox)
  private
   FItems              :TStrings;
   FDividerLine        :TBitmap;
   FMiddle             :Integer;
   FAddIndex           :Integer;
   FAddLevel           :Integer;
   FParentItem         :TPropItem;
   FRefSubProps        :Boolean;
   FSelection          :IPropListBoxSelection;
   FMouseTrackItem     :Integer;
   FCaptured           :Boolean;
   FHighlightColor     :TColor;
   FHighlightFontColor :TColor;
   FGutterColor        :TColor;
   FGutterEdgeColor    :TColor;
   FBackgroundColor    :TColor;
   FPropValueColor     :TColor;
   FPropNameColor      :TColor;
   FEditBackgroundColor:TColor;
   FEditValueColor     :TColor;
   FCategoryColor      :TColor;
   FReferenceColor     :TColor;
   FSubPropColor       :TColor;
   FReadOnlyColor      :TColor;
   FNonDefaultColor    :TColor;
   FNonDefaultFontStyle:TFontStyles;
   FShowGutter         :Boolean;
   FShowGridLines      :Boolean;
   FIndentSecondLevel  :Boolean;
   FOldWidth           :Integer;
   FOldMiddle          :Integer;
   FUseVirtualList     :Boolean;
   FOnAllowExpansion   :TAllowExpansionEvent;
   FOnGetProperties    :TGetPropertiesEvent;
   FOnGetSubProperties :TGetSubPropertiesEvent;
   FOnUpdateDirtyData  :TNotifyEvent;
   FOnAfterReset       :TNotifyEvent;
   FOnBeforeReset      :TNotifyEvent;
  protected
   function GetPropItem(Index: Integer): TPropItem;
  public
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure AdjustItem(Index: Integer);
   function CurItem: TPropItem;
   function FindItem(const Name: string): Integer;
   function Populated: Boolean;
   procedure PostUpdateMsg;
   procedure Reset;
   function SetSelectedPropertyPath(const PropPath: string): Integer;
   function SetSelectedProperty(const PropNames: string): Integer;
   property BackgroundColor: TColor;
   property PropNameColor: TColor;
   property PropValueColor: TColor;
   property EditBackgroundColor: TColor;
   property EditValueColor: TColor;
   property CategoryColor: TColor;
   property GutterColor: TColor;
   property IndentSecondLevel: Boolean;
   property GutterEdgeColor: TColor;
   property ReferenceColor: TColor;
   property SubPropColor: TColor;
   property ReadOnlyColor: TColor;
   property NonDefaultColor: TColor;
   property NonDefaultFontStyle: TFontStyles;
   property HighlightColor: TColor;
   property HighlightFontColor: TColor;
   property UseVirtualList: Boolean;
   property Items: TStrings;
   property ShowGutter: Boolean;
   property ShowGridLines: Boolean;
   property Middle: Integer;
   property Selection: IPropListBoxSelection;
   property OnAfterReset: TNotifyEvent;
   property OnAllowExpansion: TAllowExpansionEvent;
   property OnBeforeReset: TNotifyEvent;
   property OnGetProperties: TGetPropertiesEvent;
   property OnGetSubProperties: TGetSubPropertiesEvent;
   property OnUpdateDirtyData: TNotifyEvent;
  end;
